<?php
// Fungsi hitung baris
function getFileRowCount($filename) {
    if (!file_exists($filename)) return 0;
    $file = fopen($filename, "r");
    $rowCount = 0;
    while (!feof($file)) {
        fgets($file);
        $rowCount++;
    }
    fclose($file);
    return $rowCount;
}

// Deteksi protokol
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? "https" : "http";
$host = $_SERVER['HTTP_HOST'];

$path = rtrim(dirname($_SERVER['SCRIPT_NAME']), "/") . "/";

// Jika script berada di root, tetap beri "/"
if ($path == "/" || $path == "\\") {
    $path = "/";
}

$urlAsli = $protocol . "://" . $host . $path;

// File sumber (list slug)
$judulFile = "list.txt";
if (!file_exists($judulFile)) {
    die("File list.txt tidak ditemukan di lokasi: " . getcwd());
}

$fileLines = file($judulFile, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);

$sitemapFile = fopen("sitemap-gas.xml", "w");

fwrite($sitemapFile, '<?xml version="1.0" encoding="UTF-8"?>' . PHP_EOL);
fwrite($sitemapFile, '<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9">' . PHP_EOL);

foreach ($fileLines as $judul) {

    // Ambil slug mentah, TANPA diubah
    $slugRaw = trim($judul);
    if ($slugRaw == "") continue;

    // Format URL sesuai request
    // https://domain.com/?_id=1001win
    $sitemapLink = $urlAsli . "?_id=" . urlencode($slugRaw);

    fwrite($sitemapFile, "  <url>\n");
    fwrite($sitemapFile, "    <loc>$sitemapLink</loc>\n");
    fwrite($sitemapFile, "    <changefreq>monthly</changefreq>\n");
    fwrite($sitemapFile, "    <priority>0.8</priority>\n");
    fwrite($sitemapFile, "  </url>\n");
}

// Tutup tag sitemap
fwrite($sitemapFile, '</urlset>' . PHP_EOL);
fclose($sitemapFile);

echo "Successful: " . realpath("sitemap-gas.xml");
?>
